
/*----------------------------------------------------------------------------
 * Name     : timer.c
 * Purpose  : 
 * Note(s)  : 
 *---------------------------------------------------------------------------- */
#include	"timer.h"

/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
void timebase0_configure(void)
{
	_tbc = (SYSTEM_CLOCK + 0x43);		/* Fpsc=Fsys/4,period selection(2^8)=2ms */
	_tb0f = FALSE;
	_tb0e = TRUE;
	_tbon = TRUE;
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void	Delay10us(u8 cnt)
{
	while(cnt)
	{	
#if (SYSTEM_CLOCK == FSYS12MHZ)					/* for 12MHZ */
		asm volatile("mov	a,6");
#elif (SYSTEM_CLOCK == FSYS8MHZ)					/* for 8MHZ */    
		asm volatile("mov	a,4");
#else
		asm volatile("mov	a,2");					/* for 4MHZ */
#endif         	
		asm volatile("nop");		
		asm volatile("sdz	acc");
		asm volatile("jmp $-2");
		cnt--;
	}
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void DelayXmSec(u8 xs)
{
   while(xs)
   {
#if (SYSTEM_CLOCK == FSYS12MHZ) 					/* for 12MHZ */
		asm("mov		A,186");
#elif (SYSTEM_CLOCK == FSYS8MHZ)					/* for 8MHZ */    
		asm("mov		A,124");
#else
		asm("mov		A,61");							/* for 4MHZ */
#endif         	
      asm("clr wdt");
      asm("sdz acc");
      asm("jmp $-2");
      xs--;
   }
}
